%% PLOTTING I-TO-F RESPONSE

%%
clc;
clear all;
close all;


%% Selecting file
list1 = {'conv_Vctrl_3_19_500fF.csv',...    % Converter with 500 fF, td = 1 ns
         'conv_Vctrl_3_19_50fF_opt.csv',...    % Converter with 50 fF, td = 500 ps
         
         };       
     
[indx1,tf1] = listdlg('ListString', list1,'SelectionMode','single',...
                      'PromptString','Select file');
file = list1{indx1};    % Selected file


%% Extracting data
importfile(file);
[raws,columns] = size(data);

number_traces = columns/2;
i = 1;
j = 1;
k = 1;

labels_trace = {'0',...
                'Input current (I_{1})',...
                '0',...
                'Capacitor voltage (v_{cap})',...
                '0',...
                'Comparator threshold voltage (V_{comp})',...
                '0',...
                'Spike pattern (V_{spike})',...
                '0',...
                'Delayed spike pattern (V_{spike,del})',...
                '0',...
                'Output frequency (f_{out})',...             
                };

time = data(:,1);

I1 = data(:,2);
vcap = data(:,4);
vcomp = data(:,6);
spike = data(:,8);
spike_del = data(:,10);
fout = data(:,12);

figure(1);
subplot(3,1,1);
plot(time*1e9,I1*1e6,...        % [in uA]
     'Color','r','LineWidth',1.5);
%             pbaspect([1 1 1]);
xlabel('Time [ns]');
ylabel('Input current [\muA]');
xlim([0 124]);
%         ylim([0 50]);
hold on;
grid on;
%     title('I_{DS} - V_{DS}')    


% switch file
%     case 'conv_Vctrl_3_19_500fF.csv'
%         print -depsc epsFig_I1_Vctrl_3_19_500fF;
%     case 'conv_Vctrl_3_19_50fF_opt.csv'
%         print -depsc epsFig_I1_Vctrl_3_19_50fF_opt;
% end


subplot(3,1,2);
for i = 4:2:10        
    plot(time*1e9,data(:,i),...        
         'DisplayName',char(labels_trace(i)),'LineWidth',1.5);
    xlabel('Time [ns]');
    ylabel('Voltage [V]');
xlim([0 124]);
    ylim([0 4]);
    hold on;
    grid on;
%     legend('-DynamicLegend');
%     legend('show');    
%     legend('Location','northeast');
%     legend('FontSize',7);
end

% switch file
%     case 'conv_Vctrl_3_19_500fF.csv'
%         print -depsc epsFig_Voltages_Vctrl_3_19_500fF;
%     case 'conv_Vctrl_3_19_50fF_opt.csv'
%         print -depsc epsFig_Voltages_Vctrl_3_19_50fF_opt;
% end



subplot(3,1,3);
plot(time*1e9,fout*1e-6,...        % [in MHz]
     'Color','g','LineWidth',1.5);
%             pbaspect([1 1 1]);
xlabel('Time [ns]');
ylabel('Output frequency [MHz]');
xlim([0 124]);
%         ylim([0 50]);
hold on;
grid on;
%     title('I_{DS} - V_{DS}')     
% legend('FontSize',6);

switch file
    case 'conv_Vctrl_3_19_500fF.csv'
        print -depsc epsFig_Vctrl_3_19_500fF;
    case 'conv_Vctrl_3_19_50fF_opt.csv'
        print -depsc epsFig_Vctrl_3_19_50fF_opt;
end





